function y = diode_clipper_bilinear_trivial(x, fs)
    
  % x = input of the system
  % fs = sampling frequency
  % alpha = simple real pole of the AA-IIR filter
  % y = output without antialiasing
  
  % constants
  
  % circuit components
  
  VT = 0.025;
  Is = 1e-15;
  R = 1e3;
  C = 33e-9;
  
  % fs
  
  k1 = 1/(2 * fs * R * C + 1);
  k2 = Is * R/(2 * fs * R * C + 1);
  k3 = 1/(VT * (2 * fs * R * C + 1));
  k4 = (VT * (2 * fs * R * C + 1) * log((Is * R)/(VT * (2 * fs * R * C + 1))) + Is * R)/(VT * (2 * fs * R * C + 1));
   
  function y = f(x)
    y = k1 * x + sign(x) * (k2 - VT * omega(k3 * abs(x) + k4));
  endfunction

  % initial conditions

  y_z1 = 0;
  Dy_z1 = 0;
  
  % audio rate
  
  for i = 1:length(x)
    
    y(i) = f(x(i) + R * C * (2 * fs * y_z1 + Dy_z1));
    
    Dy_z1 = 2 * fs * (y(i) - y_z1) - Dy_z1;
    y_z1 = y(i);
    
  endfor
      
endfunction


function y = omega(x)
  
  if (x <= 400)
    y = lambertw(exp(x));
  else
    y = x - log(x);
  endif
  
endfunction