function y = diode_clipper_euler_trivial(x, fs)
    
  % x = input of the system
  % fs = sampling frequency
  % alpha = simple real pole of the AA-IIR filter
  % y = output without antialiasing
  
  % constants
  
  % circuit components
  
  VT = 0.025;
  Is = 1e-15;
  R = 1e3;
  C = 33e-9;
  
  % fs
  
  k1 = 1/(fs * R * C + 1);
  k2 = Is * R/(fs * R * C + 1);
  k3 = 1/(VT * (fs * R * C + 1));
  k4 = (VT * (fs * R * C + 1) * log((Is * R)/(VT * (fs * R * C + 1))) + Is * R)/(VT * (fs * R * C + 1));
   
  function y = f(x)
    y = k1 * x + sign(x) * (k2 - VT * omega(k3 * abs(x) + k4));
  endfunction

  % initial conditions

  y_z1 = 0;
  
  % audio rate
  
  for i = 1:length(x)
    
    y(i) = f(x(i) + fs * R * C * y_z1);
    
    y_z1 = y(i);
    
  endfor
      
endfunction


function y = omega(x)
  
  if (x <= 400)
    y = lambertw(exp(x));
  else
    y = x - log(x);
  endif
  
endfunction